<?php

namespace Ait\SystemApi;


class Response
{

	protected $rawResponse;
	protected $endpoint = '';
	protected $requestArgs = array();
	protected $isDownloadRequest = false;



	/**
	 * @param \WP_Error|array $rawResponse
	 */
	public function __construct($rawResponse, $endpoint, $requestArgs = array())
	{
		$this->rawResponse = $rawResponse;
		$this->endpoint = $endpoint;
		$this->requestArgs = $requestArgs;
		$this->isDownloadRequest = (isset($requestArgs['stream']) and isset($requestArgs['filename']));
	}



	/**
	 * Flag wether request was successful
	 * @return boolean
	 */
	public function isSuccessful()
	{
		if(is_wp_error($this->rawResponse)){
			return false;
		}elseif(!$this->code(200)){
			return false;
		}
		return true;
	}



	public function data()
	{
		if($this->isSuccessful() and ($body = $this->body())){
			$body = @json_decode($body);
			if(is_object($body)){
				if($this->requestArgs['_as_array'] === true){
					return (array) $body->data;
				}else{
					return $body->data;
				}
			}else{
				return array();
			}
		}else{
			return array();
		}
	}




	public function error()
	{
		if(is_wp_error($this->rawResponse)){
			return $this->rawResponse;
		}

		if(!$this->code(200)){
			if($this->isDownloadRequest){
				$msg = base64_decode($this->header('ait-api-download-error'));
				return new \WP_Error('ait_api_download_error', $msg);
			}else{
				$json = @json_decode($this->body());
				if(is_object($json)){
					return new \WP_Error('ait_api_error', $json->error);
				}else{ // server did not return JSON string but some crap, maybe 500 server interal error message
					error_log('Server response is not valid JSON. It is: ' . $this->body());
					return new \WP_Error('ait_api_error', 'Can not fulfil the request. Reaseon: Server response is not valid JSON.');
				}
			}
		}

		return null;
	}



	public function code($codeToCheck = null)
	{
		$responseCode = wp_remote_retrieve_response_code($this->rawResponse);
		if($codeToCheck){
			return $responseCode == $codeToCheck;
		}
		return $responseCode;
	}



	public function body()
	{
		return wp_remote_retrieve_body($this->rawResponse);
	}



	public function headers()
	{
		return wp_remote_retrieve_headers($this->rawResponse);
	}



	public function header($header)
	{
		return wp_remote_retrieve_header($this->rawResponse, $header);
	}



	public function endpoint()
	{
		return $this->endpoint;
	}



	public function requestArgs()
	{
		return $this->requestArgs;
	}

}
