/*
 * AIT WordPress Theme
 *
 * Copyright (c) 2012, Affinity Information Technology, s.r.o. (http://ait-themes.com)
 */
var burgerMenuData = [
	{
		selectors: ['.header-container'], 
		reservedSelectors: [/*'li.menu-item-wrapper',*/'.header-container .site-logo', '.header-container .site-tools']
	},
	{
		selectors: ['.sticky-menu .grid-main'], 
		reservedSelectors: [/*'li.menu-item-wrapper',*/'.sticky-menu .site-logo']
	}
];

/* Main Initialization Hook */
jQuery(document).ready(function(){
	/* menu.js initialization */
	desktopMenu();
	responsiveMenu();

	prepareBurgerMenus(burgerMenuData);
	burgerMenuSizes(burgerMenuData);
	burgerMenus(burgerMenuData);

	currentMenuItemFix();
	responsiveMenuFix();
	/* menu.js initialization */

	/* portfolio-item.js initialization */
	portfolioSingleToggles();
	/* portfolio-item.js initialization */

	/* custom.js initialization */
	renameUiClasses();
	removeUnwantedClasses();

	initWPGallery();
	initColorbox();
	initRatings();
	//initInfieldLabels();
	initSelectBox();

	notificationClose();
	/* custom.js initialization */

	/* Theme Dependent FIX Functions */
		/* LANGWITCH */
		fixLanguageMenu();
		/* LANGWITCH */
	anchorMenuClick();
	topMenuClickHack();
	anchorScrollOnLoad();
	/* Theme Dependent FIX Functions */
});

jQuery(window).on('hashchange', function(e){
	currentMenuItemFix();

	console.log('hashchange occured');
});

jQuery(window).resize(function(){
	responsiveMenuFix();
	burgerMenuSizes(burgerMenuData);
	burgerMenus(burgerMenuData);
});

jQuery(document).on('burger-menu-recalc', function(e){
	setTimeout(function(){
		burgerMenuSizes(burgerMenuData);
		burgerMenus(burgerMenuData);
	}, 50);
});
/* Main Initialization Hook */

/* Theme Dependenent Fix Functions */

// Langwitch | Language Dropdown
function fixLanguageMenu(){
	if(isResponsive(640)){
		// only run at 640px-
		jQuery('.language-icons a.current-lang').bind('touchstart MSPointerDown', function(){
			if(jQuery('.language-icons').hasClass('menu-opened')){
				jQuery('.language-icons .language-icons__list').hide();
			} else {
				jQuery('.language-icons .language-icons__list').show();
			}
			jQuery('.language-icons').toggleClass('menu-opened');

			return false;
		});
	}
}

function topMenuClickHack(){
	var baseHref = location.protocol + '//' + location.host + location.pathname;
	jQuery('.main-nav ul li:not(.menu-item-wrapper) > a').on('click', function(e){
		if(jQuery(this).attr('href').indexOf(baseHref) !== -1){
			// same page url .. just scroll
			var hash = jQuery(this).attr('href').replace(new RegExp(baseHref, 'g'), "");
			var aTag = jQuery(this).hasClass('custom-menu-link') ? jQuery(aTagLink) : jQuery('.elm-anchor a[id="' + hash.replace('#', '') + '"]');


			// cancel animation if user scrolls manually
			jQuery("html, body").bind("scroll mousedown DOMMouseScroll mousewheel keyup", function(){
				jQuery('html, body').stop();
			});

			jQuery('html, body').animate({
				scrollTop: aTag.offset().top
			}, 1000, function(){
				jQuery("html, body").unbind("scroll mousedown DOMMouseScroll mousewheel keyup");
				window.history.pushState("", "", hash);
				jQuery(window).trigger('hashchange');
			});
		} else {
			// other page url .. do link action
		}
	});
}

function anchorMenuClick() {
	// menu item click
	jQuery('.anchor-menu-item a').on("click", function(e){
		e.preventDefault();
		var aTagLink = jQuery(this).attr('href');
		var aTag = jQuery(this).hasClass('custom-menu-link') ? jQuery(aTagLink) : jQuery('.elm-anchor a[id="' + aTagLink.replace('#', '') + '"]');
		
		// cancel animation if user scrolls manually
		jQuery("html, body").bind("scroll mousedown DOMMouseScroll mousewheel keyup", function(){
			jQuery('html, body').stop();
		});

		jQuery('html, body').animate({
			scrollTop: aTag.offset().top
		}, 1000, function(){
			jQuery("html, body").unbind("scroll mousedown DOMMouseScroll mousewheel keyup");
			window.history.pushState("", "", aTagLink);
			jQuery(window).trigger('hashchange');
		});
	});

	jQuery('a.single-anchor').on("click", function(e){
		e.preventDefault();
		var aTagLink = jQuery(this).attr('href');
		var aTag = jQuery(aTagLink);

		// cancel animation if user scrolls manually
		jQuery("html, body").bind("scroll mousedown DOMMouseScroll mousewheel keyup", function(){
			jQuery('html, body').stop();
		});

		jQuery('html, body').animate({
			scrollTop: aTag.offset().top
		}, 1000, function(){
			jQuery("html, body").unbind("scroll mousedown DOMMouseScroll mousewheel keyup");
			window.history.pushState("", "", aTagLink);
			jQuery(window).trigger('hashchange');
		});
	});
}

function responsiveMenuFix(){
	// need to know what type of menu is defaultly shown .. maybe data param
	var $container = jQuery('#masthead');
	var defaultHeader = $container.attr('data-defaultHeader');

	if(isResponsive(768)){
		// on this responsive resolution change the classes back 
		// if the menu is over => logo-white menu-white
		// if the menu is before => logo-black menu-black

		// on this responsive resolution, menu detaches and is attached before the video-header ... so it becames before
		if(defaultHeader === "header-over"){
			// only appliable when header is set to over
			$container.removeClass('header-over').addClass('header-before');
		}
	} else {
		if(defaultHeader === "header-over"){
			// only appliable when header is set to over
			$container.removeClass('header-before').addClass('header-over');
		}
	}
}

function anchorScrollOnLoad(){
	var hash = window.location.hash;
	if(hash.replace(new RegExp("#", 'g'), "").length != 0){
		if(jQuery(hash).length != 0){
			jQuery('html, body').animate({
				scrollTop: jQuery(hash).offset().top
			}, 1000, function(){});
		}
	}
}
/* Theme Dependenent Fix Function */
