<?php

/*
 * AIT WordPress Theme
 *
 * Copyright (c) 2013, Affinity Information Technology, s.r.o. (http://ait-themes.com)
 */

// === Usefull debugging constants ===================================

// if(!defined('AIT_DISABLE_CACHE')) define('AIT_DISABLE_CACHE', true);
// if(!defined('AIT_ENABLE_NDEBUGGER')) define('AIT_ENABLE_NDEBUGGER', true);


// === Loads AIT WordPress Framework ================================
require_once get_template_directory() . '/ait-theme/@framework/load.php';


// === Mandatory WordPress Standard functionality ===================

if(!isset($content_width)) $content_width = 1000;


// === Custom filters, actions for framework overrides ==============




// === Run the theme ===============================================

// === Run the theme ===============================================
$themeConfiguration = include aitPath('config', '/@theme-configuration.php');

AitTheme::run($themeConfiguration);


// === Custom settings ==============================================

add_filter('loop_shop_columns', create_function('', 'return 3;'));

if ( aitIsPluginActive( "woocommerce" ) ) {
	add_action('ait-theme-activation', 'woocommerce_image_sizes', 1);
	function woocommerce_image_sizes(){
		update_option( 'shop_catalog_image_size', array('width' => '300', 'height' => '300', 'crop' => 1) );
		update_option( 'shop_single_image_size', array('width' => '600', 'height' => '600', 'crop' => 1) );
		update_option( 'shop_thumbnail_image_size', array('width' => '180', 'height' => '180', 'crop' => 1) );
	}
}

// Disable woocommerce default styles
if ( aitIsPluginActive( "woocommerce" ) ) {
	if ( version_compare( WOOCOMMERCE_VERSION, "2.1" ) >= 0 ) {
		add_filter( 'woocommerce_enqueue_styles', '__return_false' );
	} else {
		define( 'WOOCOMMERCE_USE_CSS', false );
	}
}

// Change number of related products on product page
// Set your own value for 'posts_per_page'
add_filter( 'woocommerce_output_related_products_args', 'ait_related_products_args' );
function ait_related_products_args( $args ) {
	$args['posts_per_page'] = 3; // 3 related products
	$args['columns'] = 3; // arranged in 2 columns
	return $args;
}